#include <bits/stdc++.h>

#define int long long

#define pb push_back

const int N = 2e5 + 10;

using namespace std;

struct fenwick {
    vector<int>ft;
    void build(int n) {
        ft.resize(n + 10);
    }
    void update(int index,int n,int val) {
        while(index <= n) {
            ft[index] += val;
            index += index & -index;
        }
    }
    int get(int index) {
        int res = 0;
        while(index >= 1) {
            res += ft[index];
            index -= index & -index;
        }
        return res;
    }
};

int lg(int x) {
    int res = 0;
    while(x > 0) {
        res += 1;
        x /= 2;
    }
    return res;
}

signed main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n,q;
    cin >> n;
    vector<int>a(n + 1);
    fenwick fenw[60];
    for(int i = 0; i < 60; i++) fenw[i].build(n);
    for(int i = 1; i <= n; i++) {
        cin >> a[i];
        fenw[lg(a[i])].update(i,n,1);
    }
    cin >> q;
    while(q--) {
        int l,r;
        cin >> l >> r;
        if(l < 0) {
            fenw[lg(a[-l])].update(-l,n,-1);
            fenw[lg(r)].update(-l,n,1);
            a[-l] = r;
            continue;
        }
        bool ok = true;
        for(int j = 0; j < 60; j++) {
            int x = fenw[j].get(r) - fenw[j].get(l - 1);
            if(x % 2 == 0 && x != 0) ok = false;
        }
        if(ok) cout << "1\n";
        else cout << "0\n";
    }
    return 0;
}